(window["webpackJsonpCoveoForSitecore"] = window["webpackJsonpCoveoForSitecore"] || []).push([["SendAnalyticsToSitecore"],{

/***/ "./src/rest/EndpointCaller.ts":
/*!************************************!*\
  !*** ./src/rest/EndpointCaller.ts ***!
  \************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var coveo_search_ui_1 = __webpack_require__(/*! coveo-search-ui */ "coveo-search-ui");
var EndpointCallerWrapper = /** @class */ (function () {
    function EndpointCallerWrapper(endpointCaller) {
        this.endpointCaller = endpointCaller || new coveo_search_ui_1.EndpointCaller();
    }
    EndpointCallerWrapper.prototype.sendPost = function (url, postData) {
        var callOptions = {
            errorsAsSuccess: false,
            method: "POST",
            queryString: [],
            requestData: postData,
            url: url,
            responseType: "text",
            requestDataType: "application/json"
        };
        return this.endpointCaller.call(callOptions);
    };
    return EndpointCallerWrapper;
}());
exports.EndpointCallerWrapper = EndpointCallerWrapper;


/***/ }),

/***/ "./src/ui/analytics/SendAnalyticsToSitecore.ts":
/*!*****************************************************!*\
  !*** ./src/ui/analytics/SendAnalyticsToSitecore.ts ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var EndpointCaller_1 = __webpack_require__(/*! ../../rest/EndpointCaller */ "./src/rest/EndpointCaller.ts");
var ContextEvents_1 = __webpack_require__(/*! ../../events/ContextEvents */ "./src/events/ContextEvents.ts");
var coveo_search_ui_1 = __webpack_require__(/*! coveo-search-ui */ "coveo-search-ui");
var SendAnalyticsToSitecore = /** @class */ (function (_super) {
    __extends(SendAnalyticsToSitecore, _super);
    function SendAnalyticsToSitecore(element, options, bindings) {
        var _this = _super.call(this, element, SendAnalyticsToSitecore.ID, bindings) || this;
        _this.element = element;
        _this.options = options;
        _this.bindings = bindings;
        _this.options = coveo_search_ui_1.ComponentOptions.initComponentOptions(element, SendAnalyticsToSitecore, options);
        _this.endpointCaller = new EndpointCaller_1.EndpointCallerWrapper();
        _this.bind.onRootElement(ContextEvents_1.SitecoreContextEvents.onSitecoreContextInitialization, _this.onSitecoreContextInitialization);
        return _this;
    }
    SendAnalyticsToSitecore.prototype.onSitecoreContextInitialization = function (sitecoreContext) {
        var _this = this;
        if (sitecoreContext.analyticsEnabled) {
            this.bind.onRootElement(coveo_search_ui_1.AnalyticsEvents.searchEvent, function (args) {
                _this.postAnalytics("searches", "searchEvents", args.searchEvents, sitecoreContext);
            });
            this.bind.onRootElement(coveo_search_ui_1.AnalyticsEvents.documentViewEvent, function (args) {
                _this.postAnalytics("documentViews", "documentViewEvents", args.documentViewEvent, sitecoreContext);
            });
            this.bind.onRootElement(coveo_search_ui_1.AnalyticsEvents.customEvent, function (args) {
                _this.postAnalytics("custom", "customEvents", args.customEvent, sitecoreContext);
            });
        }
    };
    SendAnalyticsToSitecore.prototype.postAnalytics = function (eventAction, eventType, eventData, sitecoreContext) {
        var parsedEventData = [];
        if (typeof (eventData) !== "undefined") {
            parsedEventData = parsedEventData.concat(eventData);
        }
        parsedEventData.filter(function (data) {
            return typeof (data) !== "undefined";
        }).forEach(function (data) {
            data.sitecoreItemId = sitecoreContext.sitecoreItemId;
        });
        var postData = {};
        postData[eventType] = JSON.stringify(parsedEventData);
        this.endpointCaller.sendPost(this.options.scAnalyticsEndpointUri + "/" + eventAction, postData);
    };
    SendAnalyticsToSitecore.ID = "SendAnalyticsToSitecore";
    SendAnalyticsToSitecore.options = {
        scAnalyticsEndpointUri: coveo_search_ui_1.ComponentOptions.buildStringOption({
            required: true,
            postProcessing: function (value) {
                return typeof (value) !== "undefined" && value[value.length - 1] === "/" ? value.slice(0, value.length - 1) : value;
            }
        })
    };
    return SendAnalyticsToSitecore;
}(coveo_search_ui_1.Component));
exports.SendAnalyticsToSitecore = SendAnalyticsToSitecore;
coveo_search_ui_1.Initialization.registerAutoCreateComponent(SendAnalyticsToSitecore);


/***/ })

}]);
//# sourceMappingURL=SendAnalyticsToSitecore.js.map